#!/bin/bash

# The SBATCH directives must appear before any executable line in this script.

#SBATCH --qos high2         # QOS (priority).
#SBATCH -N 1               # Number of nodes requested.
#SBATCH -n 1               # Number of tasks (i.e. processes).
#SBATCH --cpus-per-task=1  # Number of cores per task.
#SBATCH --gres=gpu:1       # Number of GPUs.
#SBATCH -t 60-00:00          # Time requested (D-HH:MM).
#SBATCH --nodelist=em5    # Uncomment if you need a specific machine.

# Uncomment this to have Slurm cd to a directory before running the script.
# You can also just run the script from the directory you want to be in.
#SBATCH -D /home/code/test_time_training/ttt_mae

# Uncomment to control the output files. By default stdout and stderr go to
# the same place, but if you use both commands below they'll be split up.
# %N is the hostname (if used, will create output(s) per node).
# %j is jobid.
##SBATCH -o slurm.%N.%j.out    # STDOUT
##SBATCH -e slurm.%N.%j.err    # STDERR

# Print some info for context.
source ~/.bashrc
conda activate taming
cd /home/code/test_time_training/ttt_mae

nvidia-smi
# Python will buffer output of your script unless you set this.
# If you're not using python, figure out how to turn off output
# buffering when stdout is a file, or else when watching your output
# script you'll only get updated every several lines printed.
export PYTHONUNBUFFERED=1
DATA_PATH='/home/group/ilsvrc/'


RESUME_MODEL='/home/code/deep_transformer_prior/mae_orig/demo/mae_visualize_vit_large.pth'
RESUME_FINETUNE='/home/code/deep_transformer_prior/mae_orig/output_dir/mae_orig_finetune_with_decoder/checkpoint-89.pth'
OUTPUT_DIR='/home/code/test_time_training/ttt_mae/output_dir/finetuned_model/online'
TIME=$(date +%s%3N)


echo $OUTPUT_DIR

python -m torch.distributed.launch --nproc_per_node=1 main_test_time_training.py \
        --data_path ${DATA_PATH} \
        --model mae_vit_large_patch16 \
        --input_size 224 \
        --batch_size 128 \
        --mask_ratio 0.75 \
        --blr 1e-4 \
        --output_dir ${OUTPUT_DIR} \
        --dist_url "file://$OUTPUT_DIR/$TIME" \
        --finetune_mode 'encoder' \
        --resume_model ${RESUME_MODEL} \
        --resume_finetune ${RESUME_FINETUNE} \
        --online


# Print completion time.
date